#your data: Average Mock 
#time
x<-c(-44,-43,-42,-41,-40,-39,-38,
     -37,-36,-35,-34,-33,-32,-31,-30,-29,-28,-27,-26,-25,-24,-23,-22,-21,-20,-19,-18,-17,-16,-15,-14,-13,
     -12,-11,-10,-9,-8,-7,-6,-5,-4,-3,-2,-1,0)
#intensity
y<-c(0.680688707,
     0.72037626,
     0.727145334,
     0.719031345,
     0.712152433,
     0.771556368,
     0.790455536,
     0.789405409,
     0.83826245,
     0.874763993,
     0.880104624,
     0.89791797,
     0.917890759,
     0.93063454,
     0.943203597,
     0.931931753,
     0.98612881,
     0.978529545,
     0.967837732,
     0.983519045,
     0.995705611,
     0.975248422,
     0.985718423,
     0.999999999,
     0.98277073,
     0.998730197,
     0.965032983,
     0.97596897,
     0.952547841,
     0.979153912,
     0.960542025,
     0.936395785,
     0.942292888,
     0.948765458,
     0.933549548,
     0.908930624,
     0.911090488,
     0.870973616,
     0.866684178,
     0.861555359,
     0.82803837,
     0.805681575,
     0.753988588,
     0.742304739,
     0.778672367)
library(splines)
spline <- interpSpline(x,y)
plot(spline)
points(x,y)

library(ggplot2)
df<-as.data.frame(cbind(x,y))
g<-ggplot(df,aes(x,y))+stat_smooth(method="loess")+geom_smooth(method="loess")

fit<-loess(y~x,data=df)

#y predictions with loess fit in range of x 

x.range<-min(df$x):max(df$x)
df$pred.y<-predict(fit,x.range)
df$pred.y
#pred.y used as smoothening curve
#pewd.y y  :   [1] 0.6615312 0.6876790 0.7127940 0.7369072 0.7600495 0.7822520 0.8035579 0.8239430 0.8433363 0.8616672 0.8788647 0.8948582
#[13] 0.9101496 0.9250141 0.9390405 0.9518175 0.9629339 0.9719784 0.9785450 0.9828849 0.9855727 0.9871830 0.9882904 0.9885955
#[25] 0.9875183 0.9852122 0.9818308 0.9775276 0.9724561 0.9666539 0.9599508 0.9521882 0.9432074 0.9328501 0.9212108 0.9084814
#[37] 0.8946484 0.8796985 0.8636185 0.8463950 0.8280164 0.8084844 0.7878052 0.7659854 0.7430315

#par(mfrow=c(3,1))
plot(df$x,df$y,main="original data")
plot(df$x,df$pred.y,main="loess prediction")


#first derivative is the slope (diff is pretty close)
slopes <- diff(df$pred.y)
#different lengths, let's just get rid of one point, let's say the last one
df<-df[-nrow(df),]
df$slopes<-slopes

plot(df$x,df$slopes,main="slopes")
abline(h=0,lwd=1,lty=2) #line at zero

#if first derivative is positve your intensity is growing
#if it's zero it's flattening
#if it's negative it is shrinking

#where is the slope closest to zero? peak
peak<-which.min(abs(slopes - 0))  
peak # 23th point of this dataset

df[23,] 


#     x         y    pred.y       slopes
# 23 -22 0.9857184 0.9882904 0.0003051039

#we need a scale (to be able to figure out what 20% of it is)
#split curve into before peak and after peak

left<-df[1:peak,]
right<-df[peak:nrow(df),]

#we use quantiles

#for the left side of the curve  # threshold 20% of the minimum
minl<-df$slopes[peak]

maxl<-max(left$slopes[1:(peak)])
lseq<-seq(minl,maxl,by=(maxl-minl)/100)
thrl<-quantile(lseq,0.2)
thr_x_left<-df$x[which.min(abs(df$slopes - thrl))]

#for the right side of the curve
maxr<-df$slopes[peak]
minr<-min(right$slopes)
rseq<-seq(minr,maxr,by=(maxr-minr)/100)
thrr<-quantile(rseq,0.8) 
thr_x_right<-df$x[which.min(abs(df$slopes - thrr))]

# we see how this thresholds look
#dev.off()
plot(df$x,df$y,main="original data",axes=FALSE)
axis(side=1, at=c(-44:0))
axis(side=2, at=seq(0.0, 1.0, by=0.1))
box()
abline(v=thr_x_left);abline(v=thr_x_right);abline(v=df$x[peak])
plot(spline)
points(x,y)
abline(v=thr_x_left);abline(v=thr_x_right);abline(v=df$x[peak])
plot(df$x,df$pred.y,main="loess prediction")
abline(v=thr_x_left);abline(v=thr_x_right);abline(v=df$x[peak])
plot(df$x,df$slopes,main="slopes")

abline(h=0,lwd=1,lty=2) #line at zero
abline(v=thr_x_left);abline(v=thr_x_right);abline(v=df$x[peak])

thr_x_right # phase transition from assembly
thr_x_left  # phase transition to scisison

## (-18,-27)